﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Office.Tools.Ribbon;
using Excel = Microsoft.Office.Interop.Excel;
using System.Windows.Forms;

namespace SkoroszytWinForms
{
    public partial class Ribbon1
    {
        private void Ribbon1_Load(object sender, RibbonUIEventArgs e)
        {
            Globals.Arkusz3.listBox1.Visible = false;
        }

        private void gallery1_Click(object sender, RibbonControlEventArgs e)
        {

        }

        private bool pobierzDane(List<double> dane)
        {
            try
            {
                Excel.Range zaznaczoneKomorki = 
                    Globals.ThisWorkbook.Application.ActiveWindow.Selection;

                foreach (Excel.Range komorka in zaznaczoneKomorki)
                {
                    if (komorka.Value2 != null && komorka.Value2.GetType() != typeof(String))
                        dane.Add(komorka.Value2);
                }

                return true;
            }
            catch (Exception ex)
            {
                MessageBox.Show("Funkcji agregującej można użyć tylko dla danych numerycznych", 
                    Globals.ThisWorkbook.Application.ActiveWindow.Caption);

                return false;
            }
        }

        private void button1_Click(object sender, RibbonControlEventArgs e)
        {
            /*
            List<double> dane = new List<double>();
            if (pobierzDane(dane))
            {
                MessageBox.Show("Suma liczb w zaznaczonych komórkach wynosi: "
                    + dane.Sum().ToString(), 
                    Globals.ThisWorkbook.Application.ActiveWindow.Caption);
            }*/

            Excel.Range zaznaczoneKomorki =
                Globals.ThisWorkbook.Application.ActiveWindow.Selection;            
            
            string adresZaznaczenia = zaznaczoneKomorki.Address;            
            string adresKomorkiTymczasowej = "A100";
            
            // Wykorzystanie funkcji SUM
            Globals.Arkusz1.Range[adresKomorkiTymczasowej].Formula = 
                "=SUM(" + adresZaznaczenia + ")";
            
            // Zapisanie wyniku
            double wynik = Globals.Arkusz1.Range[adresKomorkiTymczasowej].Value2;
            
            // Opróżnienie zawartości komórki tymczasowej
            Globals.Arkusz1.Range[adresKomorkiTymczasowej].Value2 = "";

            MessageBox.Show("Suma liczb w zaznaczonych komórkach wynosi: "
                    + wynik.ToString(),
                    Globals.ThisWorkbook.Application.ActiveWindow.Caption);                        
        }

        private void button2_Click(object sender, RibbonControlEventArgs e)
        {
            List<double> dane = new List<double>();
            if (pobierzDane(dane))
            {
                MessageBox.Show("Średnia z liczb w zaznaczonych komórkach wynosi: "
                    + dane.Average().ToString(), 
                    Globals.ThisWorkbook.Application.ActiveWindow.Caption);
            }
        }

        private void button3_Click(object sender, RibbonControlEventArgs e)
        {
            List<double> dane = new List<double>();
            if (pobierzDane(dane))
            {
                MessageBox.Show("Minimalna wartość w zaznaczonych komórkach wynosi: "
                    + dane.Min().ToString(), 
                    Globals.ThisWorkbook.Application.ActiveWindow.Caption);
            }
        }

        private void button4_Click(object sender, RibbonControlEventArgs e)
        {
            List<double> dane = new List<double>();
            if (pobierzDane(dane))
            {
                MessageBox.Show("Minimalna wartość w zaznaczonych komórkach wynosi: "
                    + dane.Max().ToString(), 
                    Globals.ThisWorkbook.Application.ActiveWindow.Caption);
            }
        }

        private void button5_Click(object sender, RibbonControlEventArgs e)
        {            
            Globals.ThisWorkbook.ActionsPane.Clear();
            if(Globals.ThisWorkbook.ActionsPane.Controls.Count == 0)
            {
                ActionsPaneControl1 actionsPane = new ActionsPaneControl1();
                Globals.ThisWorkbook.ActionsPane.Controls.Add(actionsPane);
            }
            Globals.ThisWorkbook.ActionsPane.Show();            
        }

        private void toggleButton1_Click(object sender, RibbonControlEventArgs e)
        {
            if (toggleButton1.Checked == true)
                Globals.ThisWorkbook.SheetChange += new 
                    Excel.WorkbookEvents_SheetChangeEventHandler(ThisWorkbook_SheetChange);
            else
                Globals.ThisWorkbook.SheetChange -= ThisWorkbook_SheetChange;
        }

        void ThisWorkbook_SheetChange(object Sh, Excel.Range Target)
        {
            DateTime aktualnaData = DateTime.Now;
            Globals.Arkusz3.listBox1.Items.Add(aktualnaData.Hour
                + "." + aktualnaData.Minute
                + " Adres zmienionej komórki: "
                + Target.Address
                + " Wartość: "
                + Target.Value2.ToString());
        }

        private void toggleButton2_Click(object sender, RibbonControlEventArgs e)
        {
            Globals.Arkusz3.listBox1.Visible = toggleButton2.Checked;
        }
    }
}
